import { combineReducers } from "@reduxjs/toolkit";
import topCategory from "../slices/categorys/topCategory";
import allCategory from "../slices/categorys/allCategory";
import featureProducts from "../slices/featureProducts/featureProducts";
import vendorProducts from "../slices/vendor/vendorProducts";
import vendorProfile from "../slices/vendor/vendorProfile";
import getShippingReducer from "../slices/featureProducts/deliveryOption/getShipping";
import updateUserProfile from "../slices/user/updateProfile/getUpdateProfile";
import postUpdateUserProfile from "../slices/user/updateProfile/postUpdateProfile";
import getMyAddress from "../slices/user/address/getMyAddress";
import getCountries from "../slices/user/address/getCountries";
import getStates from "../slices/user/address/getStates";
import getCity from "../slices/user/address/getCity";
import getMyRefunds from "../slices/user/myRefund/getMyRefunds";
import postUpdateRefund from "../slices/user/myRefund/postUpdateRefund";
import postNewAddress from "../slices/user/address/postNewAddress";
import postNewReview from "../slices/user/myReviews/postUpdateReview";
import getMyWishlistSlice from "../slices/user/myWishlist/getMyWishlist";
import getMyOrdersSlice from "../slices/user/orderHistory/getOrderHistory";
import getMyReviewsSlice from "../slices/user/myReviews/getMyReviews";
import getOrderDetailsSlice from "../slices/user/orderDetails/orderDetails";
import itemVariationReducer from "../slices/featureProducts/items/itemVariations";
import postReview from "../slices/featureProducts/reviews/postReviews";
import searchProducts from "../slices/searchProducts/searchProducts";
import cartProductSlice from "../slices/cart/getCartProducts";
import storeItemInCartSlice from "../slices/cart/storeItemInCart";
import postRefundMessage from "../slices/user/myRefund/refundMessage/PostRefundMessage";
import myRefundDetails from "../slices/user/myRefund/refundMessage/getRefundDetails";
import postSelectProductReducer from "../slices/cart/selectProduct/selectProduct";
import postOrdersReducer from "../slices/order/postOrders";
import getAllOrderStatus from "../slices/trackOrder/getAllStatus";
import getTrackOrder from "../slices/trackOrder/getTrackOrder";
import getMyRefundWallet from "../slices/user/myRefund/refundWallet/getMyRefundWallet";
import popularProducts from "../slices/popularProducts/popularProducts";
import bestSellers from "../slices/bestSellers/bestSellers";
import getPreferences from "../slices/preferences/getPreferences";
import applyCouponReducer from "../slices/cart/coupon/applyCoupon";
import deleteCouponReducer from "../slices/cart/coupon/deleteCoupon";
import selectForOrderReducer from "../slices/cart/order/selectForOrder";
import registrationReducer from "../slices/auth/registration";
import signInReducer from "../slices/auth/signIn";
import reCaptchaReducer from "../slices/auth/reCaptcha";
import homeBannerReducer from "../slices/homeBanner/homeBanner";
import networkReducer from "../slices/network/network";
import languageReducer from "../slices/language/language";
import deleteUserReducer from "../slices/user/deleteUser/deleteUser";
const rootReducer = combineReducers({
    topCategory,
    allCategory,
    featureProducts,
    vendorProducts,
    vendorProfile,
    getShippingReducer,
    popularProducts,
    bestSellers,
    updateUserProfile,
    postUpdateUserProfile,
    getMyAddress,
    getCountries,
    getStates,
    getCity,
    postNewAddress,
    postNewReview,
    postUpdateRefund,
    getMyWishlistSlice,
    getMyOrdersSlice,
    getMyReviewsSlice,
    postRefundMessage,
    myRefundDetails,
    getMyRefunds,
    getMyRefundWallet,
    getTrackOrder,
    getAllOrderStatus,
    postReview,
    getOrderDetailsSlice,
    itemVariationReducer,
    searchProducts,
    cartProductSlice,
    getPreferences,
    storeItemInCartSlice,
    postSelectProductReducer,
    postOrdersReducer,
    applyCouponReducer,
    deleteCouponReducer,
    selectForOrderReducer,
    registrationReducer,
    signInReducer,
    homeBannerReducer,
    networkReducer,
    languageReducer,
    reCaptchaReducer,
    deleteUser: deleteUserReducer
});

export default rootReducer;
